/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.fw.servlet.pmod.datamodel.table;

import com.ibm.hwmca.fw.servlet.pmod.datamodel.table.PmSimpleCellInfo;
import com.ibm.hwmca.fw.system.ClientUserContext;
import com.ibm.hwmca.fw.system.NullContextException;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Locale;

public class PmDateCellInfo
extends PmSimpleCellInfo {
    private String pattern;

    public void setDateFormatPattern(String newPattern) {
        if (newPattern != null) {
            boolean valid = false;
            boolean error = false;
            boolean hasYear = false;
            boolean hasMonth = false;
            boolean hasDate = false;
            boolean inYear = false;
            boolean inMonth = false;
            boolean inDate = false;
            int length = newPattern.length();
            block5: for (int i = 0; !error && i < length; ++i) {
                char ch = newPattern.charAt(i);
                switch (ch) {
                    case 'y': {
                        hasYear = true;
                        inYear = !inMonth && !inDate;
                        error = !inYear;
                        continue block5;
                    }
                    case 'M': {
                        hasMonth = true;
                        inMonth = !inYear && !inDate;
                        error = !inMonth;
                        continue block5;
                    }
                    case 'd': {
                        hasDate = true;
                        inDate = !inYear && !inMonth;
                        error = !inDate;
                        continue block5;
                    }
                    default: {
                        error = Character.isLetterOrDigit(ch) || !inYear && !inMonth && !inDate;
                        inYear = false;
                        inMonth = false;
                        inDate = false;
                    }
                }
            }
            if (error || !hasYear || !hasMonth || !hasDate) {
                throw new IllegalArgumentException("Date format pattern not valid: " + newPattern);
            }
        }
        this.pattern = newPattern;
    }

    public String getDateFormatPattern(Locale locale) {
        if (this.pattern != null) {
            return this.pattern;
        }
        ClientUserContext userContext = null;
        try {
            userContext = ClientUserContext.getUserContext();
        }
        catch (NullContextException e) {
            userContext = null;
        }
        if (locale == null) {
            locale = userContext != null ? userContext.getLocale() : Locale.getDefault();
        }
        SimpleDateFormat sdf = (SimpleDateFormat)DateFormat.getDateInstance(3, locale);
        if (userContext != null) {
            sdf.setTimeZone(userContext.getTimeZone());
        }
        return sdf.toPattern();
    }
}

